/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.rsf.requests;

import com.ibm.hwmca.base.rsf.BaseRemoteSupportFacility;
import com.ibm.hwmca.base.rsf.requests.BaseRsfRequestErrorIds;
import com.ibm.hwmca.base.rsf.requests.BaseRsfRequestImpl;
import com.ibm.hwmca.base.rsf.requests.PhoneListRequestBody;
import com.ibm.hwmca.base.rsf.sas.ChangePasswordRequestBody;
import com.ibm.hwmca.base.rsf.sas.CredentialResult;
import com.ibm.hwmca.base.rsf.sas.CredentialStore;
import com.ibm.hwmca.base.rsf.sas.CredentialUtils;
import com.ibm.hwmca.base.rsf.sas.LocalCredentialStore;
import com.ibm.hwmca.base.rsf.sas.UpdateSystemRequestBody;
import com.ibm.hwmca.base.util.SimServer;
import com.ibm.hwmca.fw.fcs.FcsServer;
import com.ibm.hwmca.fw.fcs.MachineId;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkEventText;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.log.MicrocodeLogAttributes;
import com.ibm.hwmca.fw.log.SystemEventLog;
import com.ibm.hwmca.fw.managed.HMC;
import com.ibm.hwmca.fw.rbf.RbfManager;
import com.ibm.hwmca.fw.rbf.RbfRequest;
import com.ibm.hwmca.fw.rbf.RbfRequestId;
import com.ibm.hwmca.fw.rbf.RbfRequestType;
import com.ibm.hwmca.fw.rcs.sas.SysInfo;
import com.ibm.hwmca.fw.rsf.RsfDisabledException;
import com.ibm.hwmca.fw.rsf.RsfException;
import com.ibm.hwmca.fw.rsf.RsfRequest;
import com.ibm.hwmca.fw.rsf.RsfRequestBody;
import com.ibm.hwmca.fw.rsf.RsfStatusListener;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.xfw.rsf.RsfMachineInfo;
import com.ibm.hwmca.xfw.rsf.XFrameRsfRequestBody;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class BaseRsfRequest
implements RsfRequest,
BaseRsfRequestErrorIds {
    private static String TRACE_MASKT = "XRSFBRQT";
    private static String TRACE_MASKF = "XRSFBRQF";
    private static String TRACE_MASKD = "XRSFBRQD";
    BaseRsfRequestImpl request;
    private boolean handlingStarted = false;
    private boolean canceling = false;
    private boolean resultReporting = false;
    public CredentialStore store = null;
    private int credentialTries = 0;
    private boolean restrictedHandlers = false;
    private static HashMap contentTypes = new HashMap();
    private static HashMap stateMappings = new HashMap();
    private static String resultProcInterfaceName = "com.ibm.hwmca.fw.rsf.RsfResultProcessor";
    private static String resultProcessorName = "com.ibm.hwmca.base.rsf.requests.BaseRsfResultProcessor";
    private static Class resultProcessorInterface;
    private static String rsfPath;
    private static String baseRsfPath;
    private static BaseRemoteSupportFacility baseRsf;
    private static final String TRSF_OFFER = "TRSF_OFFER";
    static int CREDENTIAL_TRIES;
    public static final String MACHINE_NAME = "Requesting Machine Identifier";
    private static FrameworkClassLogInfo logInfo;
    private static MicrocodeLogAttributes infoLog;
    private static MicrocodeLogAttributes infoLogDisplayError;

    public BaseRsfRequest(RsfRequestBody body, String resultProcClassName, LocalizableText description) throws IllegalArgumentException, UnsupportedOperationException {
        String reqType;
        if (body == null || resultProcClassName == null || description == null) {
            throw new IllegalArgumentException("One or more null input parameters");
        }
        try {
            Class<?> resultProcessorClass = Class.forName(resultProcClassName);
            if (!resultProcessorInterface.isAssignableFrom(resultProcessorClass)) {
                throw new IllegalArgumentException("Result processor does not implement RsfResultProcessor");
            }
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Result processor class " + resultProcClassName + " not found");
        }
        String requestBodyType = body.getClass().getName();
        boolean inTable = true;
        RbfRequestType rbfType = (RbfRequestType)contentTypes.get(requestBodyType);
        if (rbfType == null) {
            inTable = false;
        }
        RbfRequestType credRbfType = rbfType;
        if (body instanceof XFrameRsfRequestBody && (reqType = ((XFrameRsfRequestBody)body).getRequestType()) != null) {
            Trace.trace(TRACE_MASKF, "BaseRsfRequest:request type= " + reqType);
            rbfType = new RbfRequestType("com.ibm.hwmca.base.rsf.BaseRsfImpl", reqType, ((XFrameRsfRequestBody)body).getRequestTypeVersion());
            credRbfType = new RbfRequestType("com.ibm.hwmca.base.rsf.BaseRsfImpl", reqType, 0);
        }
        if (rbfType == null) {
            if (!inTable) {
                throw new UnsupportedOperationException("Request body type " + requestBodyType + "requires a 'setrequestType' for processing");
            }
            throw new UnsupportedOperationException("Request body type " + requestBodyType + "not supported");
        }
        reqType = rbfType.getType();
        this.store = BaseRsfRequest.getCredentialStoreImpl(credRbfType);
        if (!BaseRemoteSupportFacility.brokerRequests || body instanceof PhoneListRequestBody || reqType.equals("zstp")) {
            Trace.trace(TRACE_MASKD, "Rsf Request is local only");
            this.request = new BaseRsfRequestImpl(rbfType, body, description, resultProcessorName, false, 0);
        } else {
            Trace.trace(TRACE_MASKD, "Body type is " + requestBodyType);
            this.request = new BaseRsfRequestImpl(rbfType, body, description, resultProcessorName);
        }
        this.request.setRsfRequest(this);
        this.request.setRsfResultProcessor(resultProcClassName);
        Trace.trace(TRACE_MASKT, "<> BaseRsfRequest()");
    }

    BaseRsfRequest(RbfRequestId id) {
        this.request = (BaseRsfRequestImpl)RbfRequest.getRequest(id);
        Trace.trace(TRACE_MASKT, "<> BaseRsfRequest()");
    }

    BaseRsfRequest(BaseRsfRequestImpl rbfRequest) {
        if (rbfRequest == null) {
            Trace.trace(TRACE_MASKT, "<> BaseRsfRequest() null rbfRequest");
        } else {
            Trace.trace(TRACE_MASKT, "<> BaseRsfRequest() with rbfRequest");
        }
        this.request = rbfRequest;
    }

    public BaseRsfRequestImpl getImpl() {
        return this.request;
    }

    public String getId() {
        return this.request.getId();
    }

    public LocalizableText getDescription() {
        return this.request.getShortDescription();
    }

    public String getResultProcessor() {
        return this.request.getResultProcessor();
    }

    public void submit() throws IllegalStateException, UnsupportedOperationException, RsfException {
        Trace.trace(TRACE_MASKT, "-> submit()");
        if (!baseRsf.isCallHomeEnabled()) {
            RsfDisabledException e = new RsfDisabledException();
            BaseRsfRequest.logInfo("RsfRequest.submit: Rsf is not enabled", e, (short)12554);
            throw e;
        }
        if (BaseRemoteSupportFacility.SE_RSF || BaseRemoteSupportFacility.testFlag.equals("TEST_SE_REG")) {
            Set handlerSet = this.getHandlers();
            if (handlerSet.isEmpty()) {
                RsfDisabledException e = new RsfDisabledException();
                BaseRsfRequest.logInfo("RsfRequest.submit: Rsf is not enabled", e, (short)12554);
                throw e;
            }
            this.request.setHandlerSubset(handlerSet);
            this.request.setScope(2);
        }
        if (this.request.getState() != 0) {
            throw new UnsupportedOperationException("Submitted request not in new state");
        }
        RsfRequestBody requestBody = (RsfRequestBody)this.request.getBody();
        if (!requestBody.isValid()) {
            String invalidMessage = requestBody.getInvalidMessage();
            if (invalidMessage == null) {
                BaseRsfRequest.logError("RsfRequest.submit: Invalid RsfRequestBody in request", null, (short)12554);
                throw new IllegalArgumentException("Invalid RsfRequestBody object in submitted request");
            }
            BaseRsfRequest.logError("RsfRequest.submit: Invalid RsfRequestBody in request: " + invalidMessage, null, (short)12554);
            throw new IllegalArgumentException("Invalid RsfRequestBody: " + invalidMessage);
        }
        this.setMachineName(requestBody);
        if (this.store != null && BaseRemoteSupportFacility.devInfo != null && !BaseRemoteSupportFacility.devInfo.equals("BYPASS_CREDENTIALS")) {
            CredentialResult credentialResult = null;
            SysInfo credentials = null;
            RsfMachineInfo machInfo = null;
            boolean localRequest = false;
            if (requestBody.isConsoleRequest() || !(requestBody instanceof XFrameRsfRequestBody)) {
                localRequest = true;
            } else {
                machInfo = ((XFrameRsfRequestBody)requestBody).getReportingMachineInfo();
                try {
                    if (RsfMachineInfo.getLocalMachineInfo().equals(machInfo)) {
                        Trace.trace(TRACE_MASKF, "BaseRsfRequest: reporting machine info matches local console");
                        localRequest = true;
                        requestBody.setConsoleRequest(true);
                    }
                }
                catch (Exception e) {
                    Trace.trace(TRACE_MASKF, "BaseRsfRequest: exception comparing machine info: " + e.getMessage());
                }
            }
            boolean noUpdate = requestBody instanceof PhoneListRequestBody;
            if (localRequest) {
                Trace.trace(TRACE_MASKF, "BaseRsfRequest: using console credentials");
                try {
                    credentials = LocalCredentialStore.getCredentialStore().getCredential(null, noUpdate);
                }
                catch (Exception e) {
                    Trace.trace(TRACE_MASKF, "Exception getting local credentials:");
                    Trace.trace(TRACE_MASKF, e);
                }
                if (credentials == null && !noUpdate) {
                    credentialResult = CredentialUtils.getNewLocalCredentialsSynchronous();
                    Trace.trace(TRACE_MASKF, "BaseRsfRequest.submit: Credential completion status: " + credentialResult.getStatus());
                    credentials = credentialResult.getCredentials();
                }
            } else {
                Trace.trace(TRACE_MASKF, "BaseRsfRequest: using non-local credentials");
                String target = machInfo.getMachineType() + "-" + machInfo.getMachineModel() + "*" + machInfo.getMachineSerial();
                try {
                    credentials = CredentialUtils.getCredentials(target, this.store);
                }
                catch (Exception e) {
                    Trace.trace(TRACE_MASKF, "Exception getting credentials for target " + target);
                    Trace.trace(TRACE_MASKF, e);
                }
                if (credentials == null) {
                    try {
                        credentialResult = CredentialUtils.getNewCredentialsSynchronous(target, this.store);
                        Trace.trace(TRACE_MASKF, "BaseRsfRequest.submit: Credential completion status: " + credentialResult.getStatus());
                    }
                    catch (Exception e) {
                        Trace.trace(TRACE_MASKF, "Exception getting new credentials for target " + target);
                        Trace.trace(TRACE_MASKF, e);
                    }
                    credentials = credentialResult.getCredentials();
                }
            }
            if (!(credentials != null || BaseRemoteSupportFacility.consecutiveCredentialFailures++ >= BaseRemoteSupportFacility.allowedConsecutiveCredentialFailures && BaseRemoteSupportFacility.legacyBackup)) {
                RsfException e;
                if (noUpdate) {
                    String specMessage = "No local credentials stored: Account Info Download will not be attempted";
                    Trace.trace(TRACE_MASKF, specMessage);
                    e = new RsfException(specMessage);
                    throw e;
                }
                e = new RsfException("Rsf request submission error: unable to obtain credentials");
                BaseRsfRequest.logError("RsfRequest.submit: credentials error", e, (short)12554);
                throw e;
            }
            this.request.setOwningCredentials(credentials);
        } else if (requestBody instanceof ChangePasswordRequestBody) {
            this.request.setOwningCredentials(((ChangePasswordRequestBody)requestBody).getCredentials());
        } else if (requestBody instanceof UpdateSystemRequestBody) {
            this.request.setOwningCredentials(((UpdateSystemRequestBody)requestBody).getCredentials());
        }
        BaseRsfRequest.logInfo("BaseRsfRequest: submitting request " + this.request.getId() + " with description= " + this.request.getShortDescription(), null, (short)12553);
        RbfRequestId rbfId = this.request.getIdentifier();
        try {
            baseRsf.addRequest(rbfId.toString(), rbfId);
            this.request.submit();
        }
        catch (Exception e) {
            baseRsf.removeRequest(rbfId.toString());
            RsfException e2 = new RsfException(e);
            BaseRsfRequest.logInfo("RsfRequest.submit error: " + e.getMessage(), e, (short)12554);
            throw new RsfException("Error submitting request to RBF");
        }
        baseRsf.requestChanged(0, this);
        Trace.trace(TRACE_MASKT, "<- submit()");
    }

    public void addRsfStatusListener(String rsfStatusListenerClassName, String eventIdentifier) throws IllegalArgumentException, IllegalStateException {
        if (rsfStatusListenerClassName == null || eventIdentifier == null) {
            throw new IllegalArgumentException("addRsfStatusListener null parameter");
        }
        Trace.trace(TRACE_MASKT, "-> BaseRsfRequest::addRsfStatusListener() with class:" + rsfStatusListenerClassName + " for event=" + eventIdentifier);
        if (this.getState() != 0) {
            throw new IllegalStateException("RsfRequest must be in STATE_NEW to add a listener");
        }
        try {
            if (!(Class.forName(rsfStatusListenerClassName).newInstance() instanceof RsfStatusListener)) {
                BaseRsfRequest.logInfo("BaseRsfRequest.addRsfStatusListener: " + rsfStatusListenerClassName + " doesn't implement RsfStatusListener", null, (short)12557);
                throw new IllegalArgumentException("Class " + rsfStatusListenerClassName + " doesn't implement RsfStatusListener");
            }
        }
        catch (Exception e) {
            BaseRsfRequest.logInfo("BaseRsfRequest.addRsfStatusListener: error constructing rsfStatusListenerClassName", e, (short)12557);
            throw new IllegalArgumentException("RsfStatusListener class not constructed");
        }
        this.request.addStatusListener(eventIdentifier, rsfStatusListenerClassName);
        Trace.trace(TRACE_MASKT, "<- BaseRsfRequest::addRsfStatusListener()");
    }

    void setMachineName(RsfRequestBody body) {
        String netid;
        String nau;
        int len;
        try {
            byte[] nauByte = SimServer.getSimServer().readSim(7);
            for (len = 0; nauByte[len] != 0 && len < nauByte.length; ++len) {
            }
            nau = new String(nauByte, 0, len);
        }
        catch (Exception e) {
            HMC hmc = HMC.getHMC();
            nau = hmc.getName();
        }
        try {
            byte[] netidByte = SimServer.getSimServer().readSim(6);
            for (len = 0; netidByte[len] != 0 && len < netidByte.length; ++len) {
            }
            netid = new String(netidByte, 0, len);
        }
        catch (Exception e) {
            netid = "ZZZZZZZZ";
        }
        body.putAttribute(MACHINE_NAME, netid + "." + nau);
    }

    public Set getHandlers() {
        HashSet<MachineId> handlers = new HashSet<MachineId>();
        String[] hostnames = BaseRsfRequest.getPhoneServers();
        if (hostnames == null) {
            return handlers;
        }
        InetAddress iaddr = null;
        for (int i = 0; i < hostnames.length; ++i) {
            Trace.trace(TRACE_MASKF, "BaseRsfRequest.getHandlers: processing " + hostnames[i]);
            try {
                iaddr = InetAddress.getByName(hostnames[i].trim());
            }
            catch (Exception e) {
                BaseRsfRequest.logInfo("BaseRsfRequest.getHandlers: exception trying to get inet address for " + hostnames[i], e, (short)12554);
                continue;
            }
            MachineId machId = FcsServer.getFcsServer().getMachineId(iaddr);
            if (machId == null) {
                String machName = hostnames[i].trim();
                int nameIndex = machName.indexOf(".") + 1;
                if (nameIndex < machName.length()) {
                    machName = machName.substring(nameIndex);
                }
                MachineId localId = FcsServer.getFcsServer().getLocalMachineId();
                machId = new MachineId(machName, localId.getGroup(), localId.getVersion(), localId.getType(), localId.getFcsVersion(), new InetAddress[]{iaddr}, new boolean[]{true});
            }
            if (machId != null) {
                handlers.add(machId);
                continue;
            }
            BaseRsfRequest.logInfo("BaseRsfRequest.getHandlers: no machine id for " + hostnames[i] + " with InetAddress=" + iaddr, null, (short)12554);
        }
        return handlers;
    }

    public static String[] getPhoneServers() {
        String phoneServerClass = "com.ibm.hwmca.z.rsf.RsfUtils";
        String phoneServerMethod = "getRegisteredPhoneServers";
        try {
            Class<?> implClass = Class.forName(phoneServerClass);
            Method factory = implClass.getDeclaredMethod(phoneServerMethod, null);
            Object returnVal = factory.invoke(null, null);
            Trace.trace(TRACE_MASKT, "<- BaseRsfRequest.getPhoneServers() Ok for " + phoneServerMethod);
            return (String[])returnVal;
        }
        catch (Exception e) {
            BaseRsfRequest.logError("BaseRsfRequest.getPhoneServers() returning null, invocation of " + phoneServerMethod + " on " + phoneServerClass + " threw an exception.", e, (short)12554);
            return null;
        }
    }

    public static CredentialStore getCredentialStoreImpl(RbfRequestType type) {
        String storeName = (String)BaseRemoteSupportFacility.credentialStores.get(type);
        if (storeName == null) {
            return null;
        }
        Trace.trace(TRACE_MASKT, "-> BaseRsfRequest::getCredentialStoreImpl():" + storeName);
        return CredentialUtils.getCredentialStoreImpl(storeName);
    }

    public void cancel() throws IllegalStateException {
        Trace.trace(TRACE_MASKT, "-> cancel()");
        this.canceling = true;
        this.request.cancel();
        Trace.trace(TRACE_MASKT, "<- cancel()");
    }

    public int getState() {
        int state = (Integer)stateMappings.get(new Integer(this.request.getState()));
        if (state == 1 && this.handlingStarted) {
            state = 2;
        }
        if (state == 4 && !this.resultReporting) {
            state = this.canceling ? 3 : (this.handlingStarted ? 2 : 1);
        }
        return state;
    }

    public String getCallHomeServerName() {
        int state = this.getState();
        if (state == 0 || state == 1 || state == 5) {
            return null;
        }
        MachineId machine = this.request.getHandlingMachine();
        if (machine == null) {
            Trace.trace(TRACE_MASKT, "getCallHomeServerName() null machineId for " + this.request.getIdentifier());
            return "unavailable";
        }
        InetAddress[] address = machine.getNicAddresses();
        return machine.getName() + "(" + address[0].getHostAddress() + ")";
    }

    public Date getSubmitDate() {
        return this.request.getInitiationTime();
    }

    public RsfRequestBody getBody() {
        return (RsfRequestBody)this.request.getBody();
    }

    public void setReporting(boolean reporting) {
        this.resultReporting = reporting;
    }

    public void beginningHandling() {
        this.handlingStarted = true;
        baseRsf.requestChanged(1, this);
        String[] substParms = new String[]{"", this.request.getOriginMachine().getName()};
        MachineId machine = this.request.getHandlingMachine();
        if (machine != null) {
            String address = RbfManager.getRbfManager().getIpAddress(machine);
            substParms[0] = machine.getName() + "(" + address + ")";
        }
        FrameworkEventText eventText = new FrameworkEventText(734, substParms);
        new SystemEventLog(eventText, TRSF_OFFER).log();
    }

    private static void logInfo(String errorMsg, Throwable t, short errorId) {
        FrameworkLog errLog;
        Trace.trace(TRACE_MASKF, errorMsg);
        if (t != null) {
            Trace.trace(TRACE_MASKF, t);
            errLog = new FrameworkLog(logInfo, errorId, t);
        } else {
            errLog = new FrameworkLog(logInfo, errorId);
        }
        errLog.add(errorMsg);
        errLog.log(infoLog);
    }

    private static void logError(String errorMsg, Throwable t, short errorId) {
        FrameworkLog errLog;
        Trace.trace(TRACE_MASKF, errorMsg);
        if (t != null) {
            Trace.trace(TRACE_MASKF, t);
            errLog = new FrameworkLog(logInfo, errorId, t);
        } else {
            errLog = new FrameworkLog(logInfo, errorId);
        }
        errLog.add(errorMsg);
        errLog.log(infoLogDisplayError);
    }

    static {
        rsfPath = "com.ibm.hwmca.xfw.rsf.";
        baseRsfPath = "com.ibm.hwmca.base.rsf.requests.";
        baseRsf = BaseRemoteSupportFacility.getBaseRsf();
        CREDENTIAL_TRIES = 2;
        logInfo = new FrameworkClassLogInfo(-44, "RsfRequest");
        infoLog = MicrocodeLogAttributes.INFO_LOG;
        infoLogDisplayError = new MicrocodeLogAttributes(false, false, true, true, true, true, false, 0);
        Trace.trace(TRACE_MASKT, "-> static initializer");
        try {
            resultProcessorInterface = Class.forName(resultProcInterfaceName);
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "Execption: " + e.getMessage());
        }
        contentTypes.put(rsfPath + "ProblemReportRequestBody", BaseRemoteSupportFacility.retainZType0);
        contentTypes.put(rsfPath + "MicrocodeFunctionRequestBody", BaseRemoteSupportFacility.retainZType0);
        contentTypes.put(rsfPath + "RepairVerifyRequestBody", BaseRemoteSupportFacility.retainZType0);
        contentTypes.put(rsfPath + "TransmitDataRequestBody", BaseRemoteSupportFacility.retainZType0);
        contentTypes.put(rsfPath + "TopologyRequestBody", BaseRemoteSupportFacility.retainZType0);
        contentTypes.put(baseRsfPath + "PhoneListRequestBody", BaseRemoteSupportFacility.phoneListType0);
        contentTypes.put(baseRsfPath + "LicccRequestBody", BaseRemoteSupportFacility.retainZType0);
        contentTypes.put(baseRsfPath + "SoftwareRequestBody", BaseRemoteSupportFacility.retainZType0);
        contentTypes.put(baseRsfPath + "CloningRequestBody", BaseRemoteSupportFacility.retainZType0);
        contentTypes.put(baseRsfPath + "SdrRequestBody", BaseRemoteSupportFacility.sdrType0);
        contentTypes.put("com.ibm.hwmca.z.esa.EsaComFile", BaseRemoteSupportFacility.eservZType0);
        contentTypes.put("com.ibm.hwmca.p.rsf.FixpackDownloadRequestBody", BaseRemoteSupportFacility.retainZPIType0);
        contentTypes.put("com.ibm.hwmca.p.rsf.FixpackListRequestBody", BaseRemoteSupportFacility.retainZPIType0);
        contentTypes.put("com.ibm.hwmca.p.rsf.I_P_ProblemReportRequestBody", BaseRemoteSupportFacility.retainIPType0);
        contentTypes.put("com.ibm.hwmca.p.rsf.EssStorageProblemRequestBody", BaseRemoteSupportFacility.retainSSType0);
        contentTypes.put("com.ibm.hwmca.p.rsf.EssStorageDataRequestBody", BaseRemoteSupportFacility.retainSSType0);
        contentTypes.put("com.ibm.hwmca.base.rsf.sas.EnrollmentRequestBody", BaseRemoteSupportFacility.systemAuthType0);
        contentTypes.put("com.ibm.hwmca.base.rsf.sas.UpdateSystemRequestBody", BaseRemoteSupportFacility.systemAuthType0);
        contentTypes.put("com.ibm.hwmca.base.rsf.sas.ChangePasswordRequestBody", BaseRemoteSupportFacility.systemAuthType0);
        contentTypes.put("com.ibm.hwmca.p.rsf.PIRepairVerifyRequestBody", BaseRemoteSupportFacility.retainZPIType0);
        stateMappings.put(new Integer(0), new Integer(0));
        stateMappings.put(new Integer(4), new Integer(1));
        stateMappings.put(new Integer(8), new Integer(2));
        stateMappings.put(new Integer(12), new Integer(3));
        stateMappings.put(new Integer(16), new Integer(4));
        stateMappings.put(new Integer(20), new Integer(5));
        Trace.trace(TRACE_MASKT, "<- static initializer");
    }
}

